<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The update pricing scheme request details.
 */
class UpdatePricingSchemesRequest implements \JsonSerializable
{
    /**
     * @var UpdatePricingScheme[]
     */
    private $pricingSchemes;

    /**
     * @param UpdatePricingScheme[] $pricingSchemes
     */
    public function __construct(array $pricingSchemes)
    {
        $this->pricingSchemes = $pricingSchemes;
    }

    /**
     * Returns Pricing Schemes.
     * An array of pricing schemes.
     *
     * @return UpdatePricingScheme[]
     */
    public function getPricingSchemes(): array
    {
        return $this->pricingSchemes;
    }

    /**
     * Sets Pricing Schemes.
     * An array of pricing schemes.
     *
     * @required
     * @maps pricing_schemes
     *
     * @param UpdatePricingScheme[] $pricingSchemes
     */
    public function setPricingSchemes(array $pricingSchemes): void
    {
        $this->pricingSchemes = $pricingSchemes;
    }

    /**
     * Converts the UpdatePricingSchemesRequest object to a human-readable string representation.
     *
     * @return string The string representation of the UpdatePricingSchemesRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify('UpdatePricingSchemesRequest', ['pricingSchemes' => $this->pricingSchemes]);
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['pricing_schemes'] = $this->pricingSchemes;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
